﻿<%@ page language="java" contentType="application/json; charset=UTF-8"  pageEncoding="UTF-8"%>
<%@ page import="java.util.*, com.ibleaders.utility.ib_json.*"%>
<%@ page import="org.json.JSONObject"%>
<%@ page import="org.json.JSONObject.*"%>
<%@ page import="org.json.JSONArray"%>
<%@ page import="java.io.InputStreamReader"%>
<%@ page import="java.io.BufferedReader"%>
<%@ page import="java.net.URL"%>
<%@ page import="java.net.URLEncoder"%>

<%
	request.setCharacterEncoding("utf-8");
	response.setHeader("Access-Control-Allow-Origin", "*");
	response.setContentType("application/json");
	response.setStatus(200);

	//api 호출 파라미터 세팅
	String countPerPage = "15";
	String confmKey = "U01TX0FVVEgyMDIyMDgyNTEzNDIyODExMjkxNzE=";
	String searchStr = (request.getParameter("searchStr") != null) ? request.getParameter("searchStr") : "";
	String apiUrl = "https://business.juso.go.kr/addrlink/addrLinkApi.do?&countPerPage=" + countPerPage + "&keyword=" + URLEncoder.encode(searchStr,"UTF-8") + "&confmKey=" + confmKey + "&resultType=json";
	String tempStr = null;

	URL url = new URL(apiUrl);

	BufferedReader br = new BufferedReader(new InputStreamReader(url.openStream(), "UTF-8"));
	StringBuffer sb = new StringBuffer();

	int showLines;

	try {
		showLines = Integer.parseInt(request.getParameter("showLine"));
	} catch (Exception e) {
		showLines = 10;
	}

	while (true) {
		tempStr = br.readLine();
		if (tempStr == null) break;
		sb.append(tempStr); // 응답결과 JSON 저장
	}

	br.close();

	JSONObject jObject = new JSONObject(sb.toString());
	JSONObject common = jObject.getJSONObject("results").getJSONObject("common");
	JSONObject Result = new JSONObject();
	JSONObject ResString = new JSONObject();
	JSONObject res = new JSONObject();
	JSONArray jsonArr = new JSONArray();

	String errCode = common.get("errorCode").toString();
	String Enum = "";
	String EnumKey = "";
	String EditEnum = "";

	int resResult = -1;

	if (errCode.equals("0")) {
		JSONObject juso = jObject.getJSONObject("results");
		JSONArray jArray = juso.getJSONArray("juso");

		if (jArray.length() != 0) {
			for (int i = 0; i < jArray.length(); i++) {
				if (i == showLines) break;
				JSONObject obj = jArray.getJSONObject(i);
				String roadAddr = obj.getString("roadAddr");
				String bdMgtSn = obj.getString("bdMgtSn");
				String zipNo = obj.getString("zipNo");

				Enum += ("|" + roadAddr);
				EnumKey = ("|" + bdMgtSn);
				EditEnum += ("|" + roadAddr + "\t" + zipNo);
				resResult = 0;
			}
		}
	}
	ResString.put("Enum", Enum);
	ResString.put("EnumKeys", EnumKey);
	ResString.put("EditEnum", EditEnum);
	ResString.put("Result", resResult);
	out.print(ResString);
%>
